<?php
date_default_timezone_set('America/Sao_Paulo');
include_once __DIR__ . '/../conectarbanco.php';



//file_put_contents(__DIR__ . '/cron_debug.log', date('Y-m-d H:i:s') . " rodou\n", FILE_APPEND);


// Conexão com validação
$conn = new mysqli('localhost', $config['db_user'], $config['db_pass'], $config['db_name']);
if ($conn->connect_error) {
    die("Erro ao conectar no banco: " . $conn->connect_error);
}

// Valida existência do host para montar a URL
$host = $_SERVER['HTTP_HOST'] ?? 'localhost';
$https = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on';
$protocolo = $https ? 'https' : 'http';

// Query - incluindo tipo_transacao para identificar cartões de crédito
$sql = "SELECT idtransaction, adquirente_ref, tipo_transacao FROM solicitacoes WHERE status = 'WAITING_FOR_APPROVAL'";
$res = $conn->query($sql);

if ($res === false) {
    die("Erro na consulta SQL: " . $conn->error);
}

if ($res->num_rows > 0) {
    while ($row = $res->fetch_assoc()) {
        $id = trim($row['idtransaction'] ?? '');
        $adquirente = trim($row['adquirente_ref'] ?? '');
        $tipo_transacao = trim($row['tipo_transacao'] ?? '');

        // Validação
        if (empty($id) || empty($adquirente)) {
            error_log("Registro inválido ignorado (ID ou adquirente vazio)");
            continue;
        }

        // Sanitização básica para o nome do adquirente (evita path traversal)
        if (!preg_match('/^[a-zA-Z0-9_-]+$/', $adquirente)) {
            error_log("Adquirente inválido detectado: $adquirente");
            continue;
        }
        
        $url = "$protocolo://$host/api.getpaybr.com/v1/webhook/$adquirente.php?id=" . urlencode($id);

        // Requisição com tratamento de erro
        $resposta = @file_get_contents($url);
        if ($resposta === false) {
            error_log("Erro ao acessar $url");
        } else {
            // Se for transação de cartão de crédito, capturar estimatedCreditDate
            if (strtoupper($tipo_transacao) === 'CREDIT_CARD' && $adquirente === 'asaas') {
                $estimatedCreditDate = capturarEstimatedCreditDate($id, $conn);
                if ($estimatedCreditDate) {
                    atualizarSaqueDisponivel($id, $estimatedCreditDate, $conn);
                }
            }
            echo "Processado: $id<br>";
        }
    }
} else {
    echo "Nenhuma solicitação pendente.<br>";
}

$conn->close();
echo "Finalizado!";

/**
 * Captura o estimatedCreditDate do Asaas para transações de cartão de crédito
 */
function capturarEstimatedCreditDate($idTransaction, $conn) {
    // Inclui as funções do Asaas
    include_once __DIR__ . '/../v1/adquirente/asaas/asaas_functions.php';
    
    try {
        // Busca os dados da transação no Asaas
        $payment = asaasRequest("payments/$idTransaction", 'GET');
        
        if (empty($payment['id'])) {
            error_log("Transação não encontrada no Asaas: $idTransaction");
            return null;
        }
        
        // Verifica se é uma transação de cartão de crédito e se tem estimatedCreditDate
        if (isset($payment['billingType']) && $payment['billingType'] === 'CREDIT_CARD' && 
            isset($payment['estimatedCreditDate'])) {
            
            $estimatedDate = $payment['estimatedCreditDate'];
            
            // Converte para formato MySQL datetime
            $dateTime = new DateTime($estimatedDate);
            return $dateTime->format('Y-m-d H:i:s');
        }
        
        return null;
    } catch (Exception $e) {
        error_log("Erro ao capturar estimatedCreditDate para $idTransaction: " . $e->getMessage());
        return null;
    }
}

/**
 * Atualiza o campo saque_disponivel na tabela solicitacoes
 */
function atualizarSaqueDisponivel($idTransaction, $estimatedCreditDate, $conn) {
    try {
        $stmt = $conn->prepare("UPDATE solicitacoes SET saque_disponivel = ? WHERE idtransaction = ?");
        $stmt->bind_param('ss', $estimatedCreditDate, $idTransaction);
        
        if ($stmt->execute()) {
            echo "Saque disponível atualizado para $idTransaction: $estimatedCreditDate<br>";
        } else {
            error_log("Erro ao atualizar saque_disponivel para $idTransaction: " . $stmt->error);
        }
        
        $stmt->close();
    } catch (Exception $e) {
        error_log("Erro ao atualizar saque_disponivel para $idTransaction: " . $e->getMessage());
    }
}
