# Como usar a API de Pagamento

## Endpoint
```
POST https://api.getpaybr.com/v1/gateway/processa_pagamento_api.php
```

## Headers
```
Content-Type: application/json
```

## Estrutura do JSON para PIX

### Campos obrigatórios:
```json
{
  "api-key": "sua_chave_api_aqui",
  "name": "Nome do Cliente",
  "cpf": "123.456.789-00",
  "amount": "50.00",
  "tipoPagamento": "PIX",
  "email": "cliente@email.com"
}
```

### Campos opcionais:
```json
{
  "api-key": "sua_chave_api_aqui",
  "name": "Nome do Cliente",
  "cpf": "123.456.789-00",
  "amount": "50.00",
  "tipoPagamento": "PIX",
  "email": "cliente@email.com",
  "telefone": "(11) 99999-9999",
  "user_id": "identificador_do_usuario"
}
```

## Estrutura do JSON para Cartão de Crédito

```json
{
  "api-key": "sua_chave_api_aqui",
  "name": "Nome do Cliente",
  "cpf": "123.456.789-00",
  "amount": "50.00",
  "tipoPagamento": "CREDIT_CARD",
  "email": "cliente@email.com",
  "telefone": "(11) 99999-9999",
  "creditCard": {
    "number": "4111111111111111",
    "holderName": "Nome do Cliente",
    "expiryMonth": "12",
    "expiryYear": "2025",
    "ccv": "123"
  },
  "creditCardHolderInfo": {
    "name": "Nome do Cliente",
    "email": "cliente@email.com",
    "cpfCnpj": "12345678900",
    "postalCode": "01234-567",
    "addressNumber": "123",
    "address": "Rua Exemplo",
    "phone": "11999999999",
    "city": "São Paulo",
    "state": "SP"
  }
}
```

## Resposta da API

### Sucesso (PIX):
```json
{
  "status": "success",
  "idTransaction": "pay_123456789",
  "tipo": "PIX",
  "paymentCode": "00020126580014br.gov.bcb.pix0136123e4567-e12b-12d1-a456-426614174000520400005303986540510.005802BR5913Nome Empresa6008São Paulo62070503***6304E2CA",
  "qrCodeImage": "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAA...",
  "asaas": {
    "id": "pay_123456789",
    "customer": "cus_123456789",
    "value": 50.00,
    "status": "WAITING_FOR_APPROVAL"
  }
}
```

### Sucesso (Cartão):
```json
{
  "status": "success",
  "idTransaction": "pay_123456789",
  "tipo": "CREDIT_CARD",
  "asaas": {
    "id": "pay_123456789",
    "customer": "cus_123456789",
    "value": 50.00,
    "status": "CONFIRMED"
  }
}
```

### Erro:
```json
{
  "status": "error",
  "message": "Descrição do erro"
}
```

## Exemplo de uso com JavaScript

```javascript
const payload = {
  "api-key": "sua_chave_api",
  "name": "João Silva",
  "cpf": "123.456.789-00",
  "amount": "99.90",
  "tipoPagamento": "PIX",
  "email": "joao@email.com",
  "telefone": "(11) 99999-9999"
};

fetch('https://api.getpaybr.com/v1/gateway/processa_pagamento_api.php', {
  method: 'POST',
  headers: {
    'Content-Type': 'application/json'
  },
  body: JSON.stringify(payload)
})
.then(response => response.json())
.then(data => {
  if (data.status === 'success') {
    console.log('PIX gerado:', data.paymentCode);
    console.log('ID da transação:', data.idTransaction);
  } else {
    console.error('Erro:', data.message);
  }
})
.catch(error => {
  console.error('Erro na requisição:', error);
});
```

## Exemplo de uso com PHP

```php
$payload = [
    'api-key' => 'sua_chave_api',
    'name' => 'João Silva',
    'cpf' => '123.456.789-00',
    'amount' => '99.90',
    'tipoPagamento' => 'PIX',
    'email' => 'joao@email.com',
    'telefone' => '(11) 99999-9999'
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, 'https://api.getpaybr.com/v1/gateway/processa_pagamento_api.php');
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

$response = curl_exec($ch);
curl_close($ch);

$data = json_decode($response, true);

if ($data['status'] === 'success') {
    echo 'PIX gerado: ' . $data['paymentCode'];
    echo 'ID da transação: ' . $data['idTransaction'];
} else {
    echo 'Erro: ' . $data['message'];
}
```

## Códigos de Status HTTP

- `200` - Sucesso
- `400` - Dados inválidos ou campos obrigatórios ausentes
- `401` - API key inválida ou inativa
- `405` - Método HTTP não permitido
- `500` - Erro interno do servidor

## Observações Importantes

1. **API Key**: Deve ser válida e estar ativa na tabela `users_key`
2. **Valor**: Aceita formato brasileiro (vírgula como separador decimal) ou americano (ponto)
3. **CPF**: Aceita com ou sem máscara (será limpo automaticamente)
4. **Telefone**: Campo opcional, mas recomendado para notificações
5. **user_id**: Se não informado, será usado o ID do usuário da API key
