<?php
/**
 * Teste Simples da API Gateway
 * 
 * Este arquivo testa se a API está funcionando corretamente
 * Execute no navegador para ver os resultados
 */

require_once 'config.php';

echo "<h1>🧪 Teste da API Gateway</h1>";
echo "<p><strong>Versão:</strong> " . API_VERSION . "</p>";
echo "<p><strong>Ambiente:</strong> " . getConfig('ENVIRONMENT') . "</p>";
echo "<p><strong>Timestamp:</strong> " . date('Y-m-d H:i:s') . "</p>";

echo "<hr>";

// Teste de conexão com banco
echo "<h2>🔌 Teste de Conexão com Banco</h2>";
try {
    $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    
    if ($conn->connect_error) {
        echo "<p style='color: red;'>❌ Erro de conexão: " . $conn->connect_error . "</p>";
    } else {
        echo "<p style='color: green;'>✅ Conexão com banco estabelecida com sucesso</p>";
        
        // Teste de tabelas
        $tables = ['users_key', 'adquirentes', 'ad_asaas', 'solicitacoes', 'users'];
        foreach ($tables as $table) {
            $result = $conn->query("SHOW TABLES LIKE '$table'");
            if ($result->num_rows > 0) {
                echo "<p style='color: green;'>✅ Tabela '$table' encontrada</p>";
            } else {
                echo "<p style='color: red;'>❌ Tabela '$table' não encontrada</p>";
            }
        }
        
        // Verificar adquirente ativo
        $result = $conn->query("SELECT adquirente FROM adquirentes WHERE status = 1 LIMIT 1");
        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();
            echo "<p style='color: green;'>✅ Adquirente ativo: " . $row['adquirente'] . "</p>";
        } else {
            echo "<p style='color: orange;'>⚠️ Nenhum adquirente ativo encontrado</p>";
        }
        
        // Verificar configuração do Asaas
        $result = $conn->query("SELECT * FROM ad_asaas WHERE id = 1");
        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();
            echo "<p style='color: green;'>✅ Configuração do Asaas encontrada</p>";
            echo "<p><strong>URL:</strong> " . $row['url'] . "</p>";
            echo "<p><strong>Secret Key:</strong> " . substr($row['secret_key'], 0, 20) . "...</p>";
        } else {
            echo "<p style='color: red;'>❌ Configuração do Asaas não encontrada</p>";
        }
        
        $conn->close();
    }
} catch (Exception $e) {
    echo "<p style='color: red;'>❌ Erro: " . $e->getMessage() . "</p>";
}

echo "<hr>";

// Teste de funções de configuração
echo "<h2>⚙️ Teste de Funções de Configuração</h2>";
echo "<p><strong>API Base URL:</strong> " . getConfig('API_BASE_URL') . "</p>";
echo "<p><strong>URL do Asaas:</strong> " . getAsaasUrl() . "</p>";
echo "<p><strong>Taxa Padrão Cash In:</strong> " . getConfig('DEFAULT_TAXA_CASH_IN') . "%</p>";
echo "<p><strong>Taxa Padrão Cash Out:</strong> " . getConfig('DEFAULT_TAXA_CASH_OUT') . "%</p>";
echo "<p><strong>Taxa Fixa:</strong> R$ " . getConfig('DEFAULT_TAXA_FIXA') . "</p>";

echo "<hr>";

// Teste de validações
echo "<h2>✅ Teste de Validações</h2>";
$testApiKey = "teste123456789012345678901234567890";
echo "<p><strong>API Key de teste:</strong> " . $testApiKey . "</p>";
echo "<p><strong>API Key válida:</strong> " . (validateApiKey($testApiKey) ? "✅ Sim" : "❌ Não") . "</p>";

$testAmount = 100.50;
echo "<p><strong>Valor de teste:</strong> R$ " . $testAmount . "</p>";
echo "<p><strong>Valor válido:</strong> " . (validateAmount($testAmount) ? "✅ Sim" : "❌ Não") . "</p>";

echo "<hr>";

// Teste de mensagens de erro
echo "<h2>🚨 Teste de Mensagens de Erro</h2>";
echo "<p><strong>Erro API Key inválida:</strong> " . getErrorMessage('INVALID_API_KEY') . "</p>";
echo "<p><strong>Erro campos obrigatórios:</strong> " . getErrorMessage('MISSING_REQUIRED_FIELDS') . "</p>";
echo "<p><strong>Erro transação não encontrada:</strong> " . getErrorMessage('TRANSACTION_NOT_FOUND') . "</p>";

echo "<hr>";

// Teste de log
echo "<h2>📝 Teste de Log</h2>";
if (getConfig('LOG_ENABLED')) {
    logMessage('INFO', 'Teste da API Gateway executado', ['timestamp' => date('Y-m-d H:i:s')]);
    echo "<p style='color: green;'>✅ Log habilitado e funcionando</p>";
    echo "<p><strong>Arquivo de log:</strong> " . getConfig('LOG_FILE') . "</p>";
} else {
    echo "<p style='color: orange;'>⚠️ Log desabilitado</p>";
}

echo "<hr>";

// Status geral
echo "<h2>📊 Status Geral</h2>";
$status = "✅ Funcionando";
$color = "green";

if (!function_exists('curl_init')) {
    $status = "❌ cURL não disponível";
    $color = "red";
}

echo "<p style='color: $color;'><strong>Status da API:</strong> $status</p>";

if (isDevelopment()) {
    echo "<p style='color: blue;'>🔧 Modo de desenvolvimento ativo</p>";
} else {
    echo "<p style='color: green;'>🚀 Modo de produção ativo</p>";
}

echo "<hr>";

// Links úteis
echo "<h2>🔗 Links Úteis</h2>";
echo "<p><a href='exemplo-integracao.html' target='_blank'>📱 Exemplo de Integração</a></p>";
echo "<p><a href='README.md' target='_blank'>📖 Documentação</a></p>";
echo "<p><a href='criar-pagamento.php' target='_blank'>💳 Endpoint Criar Pagamento</a></p>";
echo "<p><a href='consultar-status.php' target='_blank'>🔍 Endpoint Consultar Status</a></p>";

echo "<hr>";

echo "<p><em>Teste executado em: " . date('Y-m-d H:i:s') . "</em></p>";
?>
