<?php
session_start();
include '../conectarbanco.php';

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (!isset($_GET['id'])) {
    $_SESSION['alert_message'] = "Erro: ID da solicitação não foi informado.";
    $_SESSION['alert_type'] = "error";
    header("Location: saques_usuarios.php");
    exit();
}






function debug_log($message) {
    $log_file = __DIR__ . '/asaas_cashout_log.txt';
    $timestamp = date('Y-m-d H:i:s');
    
    // Verifica se o message é um array ou objeto e converte para string
    if (is_array($message) || is_object($message)) {
        $message = print_r($message, true); // ou var_export($message, true)
    }
    
    file_put_contents($log_file, "[$timestamp] $message\n", FILE_APPEND);
}

















$solicitacao_id = $_GET['id'];

// Conectar ao banco de dados
$conn = new mysqli('localhost', $config['db_user'], $config['db_pass'], $config['db_name']);

// Verificar conexão
if ($conn->connect_error) {
    $_SESSION['alert_message'] = "Erro de conexão com o banco de dados. Tente novamente.";
    $_SESSION['alert_type'] = "error";
    header("Location: saques_usuarios.php");
    exit();
}

// Realizar a consulta usando JOIN entre as tabelas retiradas e users_key para buscar o user_id e a api_key correta
$query = "
    SELECT r.user_id, r.tipo_chave, r.chave, r.valor, r.status, uk.api_key 
    FROM retiradas AS r
    JOIN users_key AS uk ON r.user_id = uk.user_id
    WHERE r.id = ?
    LIMIT 1
";

$stmt = $conn->prepare($query);
$stmt->bind_param("i", $solicitacao_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $solicitacao = $result->fetch_assoc();
    $user_id = $solicitacao['user_id'];

    $nome_completo = '';
    $query_nome = "SELECT nome FROM users WHERE user_id = ? LIMIT 1";
    $stmt_nome = $conn->prepare($query_nome);
    $stmt_nome->bind_param("s", $user_id);
    $stmt_nome->execute();
    $stmt_nome->bind_result($nome_completo);
    $stmt_nome->fetch();
    $stmt_nome->close();
    if (empty($nome_completo)) {
        $nome_completo = 'NOME NAO ENCONTRADO';
    }

    // Verificar se a retirada já foi aprovada
    if ($solicitacao['status'] == 1) {
        $_SESSION['alert_message'] = "Esta solicitação já foi aprovada anteriormente.";
        $_SESSION['alert_type'] = "error";
        header("Location: saques_usuarios.php");
        exit();
    }

    $keypix = $solicitacao['chave'];
    $tipo_chave = $solicitacao['tipo_chave'];
    $amount = $solicitacao['valor'];
    $api_key = $solicitacao['api_key']; // A API key correta já foi recuperada diretamente

    // Buscar o CPF do usuário apenas se necessário
    $cpf_usuario = '';
    if (strtoupper($tipo_chave) === 'CPF') {
        $query_cpf = "SELECT cpf_cnpj FROM users WHERE user_id = ? LIMIT 1";
        $stmt_cpf = $conn->prepare($query_cpf);
        $stmt_cpf->bind_param("s", $user_id);
        $stmt_cpf->execute();
        $stmt_cpf->bind_result($cpf_usuario);
        $stmt_cpf->fetch();
        $stmt_cpf->close();
    }

    // Preparar os dados para a requisição
    $data = [
        "api-key" => $api_key,
        "name" => $nome_completo,
        "keypix" => $keypix,
        "amount" => $amount,
        "keyType" => strtolower($tipo_chave)
    ];

    // // Adicionar CPF apenas se o tipo de chave for CPF
    // if (strtoupper($tipo_chave) === 'CPF' && !empty($cpf_usuario)) {
    //     $data["cpf"] = $cpf_usuario;
    // }

    // Configuração da requisição cURL
    $url = "https://api.getpaybr.com/c1/cashout/";
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json'
    ]);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);

    // Executar a requisição
    debug_log('[REQ] Enviando cashout: ' . json_encode($data));
    $response = curl_exec($ch);

    // Verificar se houve algum erro na requisição cURL
    if ($response === false) {
        $error = curl_error($ch);
        debug_log('[ERR] cURL: ' . $error);
        $_SESSION['alert_message'] = "Erro de conexão com o sistema de pagamento. Tente novamente.";
        $_SESSION['alert_type'] = "error";
        header("Location: saques_usuarios.php");
        exit();
    } else {
        // Exibir a resposta da API para depuração
        $response_data = json_decode($response, true);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE); // Obter o código de status HTTP
        debug_log('[RES] HTTP ' . $http_code . ' Body: ' . $response);
        curl_close($ch);

        // Condições de SUCESSO aceitas
        // Observação: algumas integrações podem retornar HTTP 500 com corpo "success" e message "K-200".
        // Portanto, consideramos sucesso se o corpo indicar sucesso independentemente do código HTTP.
        $is_success = false;
        if (isset($response_data['status']) && in_array(strtolower((string)$response_data['status']), ['success','ok','approved'], true)) {
            $is_success = true;
        }
        if (isset($response_data['message'])) {
            $messageUpper = is_array($response_data['message']) ? '' : strtoupper((string)$response_data['message']);
            if (in_array($messageUpper, ['K-200','APPROVED'], true)) {
                $is_success = true;
            }
        }
   

        if ($is_success) {
            // Se a API retornou o objeto do Asaas com ID, gravamos como referência da retirada
            $asaasId = '';
            if (isset($response_data['asaas']) && is_array($response_data['asaas']) && isset($response_data['asaas']['id'])) {
                $asaasId = (string)$response_data['asaas']['id'];
            }

            if (!empty($asaasId)) {
                $stmtUpdateRef = $conn->prepare("UPDATE retiradas SET referencia = ? WHERE id = ?");
                if ($stmtUpdateRef) {
                    $stmtUpdateRef->bind_param("si", $asaasId, $solicitacao_id);
                    $stmtUpdateRef->execute();
                    $stmtUpdateRef->close();
                }
            }

            // Marcamos a retirada como APROVADA imediatamente para refletir o sucesso na UI
            $stmtPaid = $conn->prepare("UPDATE retiradas SET status = '1', data_pagamento = NOW() WHERE id = ?");
            if ($stmtPaid) {
                $stmtPaid->bind_param("i", $solicitacao_id);
                $stmtPaid->execute();
                $stmtPaid->close();
            }

            $_SESSION['alert_message'] = "Solicitação aprovada com sucesso.";
            $_SESSION['alert_type'] = "success";
            header("Location: saques_usuarios.php");
            exit();
        } else {
            // Se a API retornar algo inesperado, repasse mensagem amigável
            $mensagemErro = 'Falha ao enviar saque ao Asaas.';
            if (isset($response_data['asaas']['errors']) && is_array($response_data['asaas']['errors'])) {
                $descriptions = [];
                foreach ($response_data['asaas']['errors'] as $err) {
                    $descriptions[] = $err['description'] ?? $err['code'] ?? json_encode($err);
                }
                $mensagemErro = implode('; ', $descriptions);
            } elseif (isset($response_data['message'])) {
                $mensagemErro = is_array($response_data['message']) ? json_encode($response_data['message']) : $response_data['message'];
            } elseif (!empty($response)) {
                $mensagemErro = 'Resposta: ' . $response;
            }
            // var_dump($data);
            // var_dump($mensagemErro);
            // die;
            $_SESSION['alert_message'] = $mensagemErro;
            $_SESSION['alert_type'] = "error";
            header("Location: saques_usuarios.php");
            exit();
        }
    }
} else {
    $_SESSION['alert_message'] = "Solicitação não encontrada ou dados inválidos.";
    $_SESSION['alert_type'] = "error";
    header("Location: saques_usuarios.php");
    exit();
}
?>
