<?php
session_start();

include '../conectarbanco.php';

$conn = new mysqli('localhost', $config['db_user'], $config['db_pass'], $config['db_name']);
if ($conn->connect_error) {
    die('Falha na conexão: ' . $conn->connect_error);
}

// Converte valor no formato brasileiro (1.234,56) para float (1234.56)
function parseBrazilianCurrencyToFloat(string $value): float
{
    $normalized = str_replace(['.', ','], ['', '.'], trim($value));
    if ($normalized === '' || !is_numeric($normalized)) {
        return 0.0;
    }
    return (float)$normalized;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = isset($_POST['id']) ? intval($_POST['id']) : 0;
    if ($id <= 0) {
        http_response_code(400);
        echo 'ID inválido.';
        exit;
    }

    $setParts = [];
    $params = [];
    $types = '';

    // Valor é opcional ao editar; só atualiza se vier preenchido e válido
    if (isset($_POST['valor_checkout']) && trim($_POST['valor_checkout']) !== '') {
        $valorFloat = parseBrazilianCurrencyToFloat($_POST['valor_checkout']);
        
        // Validação de valor mínimo
        if ($valorFloat < 5.00) {
            header('Content-Type: application/json');
            http_response_code(400);
            echo json_encode(['success' => false, 'message' => 'Valor mínimo: R$ 5,00']);
            exit;
        }
        
        $setParts[] = 'valor = ?';
        $params[] = $valorFloat;
        $types .= 'd';
    }

    // Parcelamento é opcional ao editar
    if (isset($_POST['parcelavel'])) {
        $parcelavel = intval($_POST['parcelavel']);
        $setParts[] = 'parcelavel = ?';
        $params[] = $parcelavel;
        $types .= 'i';
    }

    // Máximo de parcelas é opcional ao editar
    if (isset($_POST['max_parcelas'])) {
        $maxParcelas = intval($_POST['max_parcelas']);
        $setParts[] = 'max_parcelas = ?';
        $params[] = $maxParcelas;
        $types .= 'i';
    }

    // Validação de valor por parcela se parcelável
    if (isset($_POST['parcelavel']) && isset($_POST['max_parcelas']) && isset($_POST['valor_checkout']) && trim($_POST['valor_checkout']) !== '') {
        $parcelavel = intval($_POST['parcelavel']);
        $maxParcelas = intval($_POST['max_parcelas']);
        $valorFloat = parseBrazilianCurrencyToFloat($_POST['valor_checkout']);
        
        if ($parcelavel == 1) {
            $valorPorParcela = $valorFloat / $maxParcelas;
            if ($valorPorParcela < 5.00) {
                header('Content-Type: application/json');
                http_response_code(400);
                echo json_encode(['success' => false, 'message' => 'Valor por parcela: R$ ' . number_format($valorPorParcela, 2, ',', '.') . ' - Mínimo: R$ 5,00']);
                exit;
            }
        }
    }

    // Página de obrigado é opcional; permite inclusive limpar (string vazia)
    if (isset($_POST['obrigado_page'])) {
        $obrigadoPage = trim($_POST['obrigado_page']);
        $setParts[] = 'obrigado_page = ?';
        $params[] = $obrigadoPage;
        $types .= 's';
    }

    // Se nada para atualizar, apenas retorna à listagem
    if (count($setParts) === 0) {
        header('Content-Type: application/json');
        echo json_encode(['success' => false, 'message' => 'Nenhum campo foi alterado.']);
        exit;
    }

    $sql = 'UPDATE checkout_build SET ' . implode(', ', $setParts) . ' WHERE id = ?';
    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        header('Content-Type: application/json');
        http_response_code(500);
        echo json_encode(['success' => false, 'message' => 'Erro ao preparar a consulta.']);
        exit;
    }

    // Adiciona o ID ao final
    $types .= 'i';
    $params[] = $id;

    $stmt->bind_param($types, ...$params);

    if ($stmt->execute()) {
        header('Content-Type: application/json');
        echo json_encode(['success' => true, 'message' => 'Checkout atualizado com sucesso!', 'redirect' => 'index.php']);
    } else {
        header('Content-Type: application/json');
        http_response_code(500);
        echo json_encode(['success' => false, 'message' => 'Erro ao atualizar o checkout.']);
    }

    $stmt->close();
}

$conn->close();
?>
