<?php
session_start();

// Verificar se o e-mail está presente na sessão
if (!isset($_SESSION['email'])) {
    header("Location: ../");
    exit;
}

include '../conectarbanco.php';

$conn = new mysqli('localhost', $config['db_user'], $config['db_pass'], $config['db_name']);
if ($conn->connect_error) {
    die("Erro na conexão com o banco de dados: " . $conn->connect_error);
}

$email = $_SESSION['email'];

// Buscar dados do usuário
$sql = "SELECT user_id, nome, status, permission FROM users WHERE email = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $email);
$stmt->execute();
$stmt->bind_result($user_id, $nome, $status, $permission);
$stmt->fetch();
$stmt->close();

$_SESSION['user_id'] = $user_id;

// Buscar integrações existentes
$meta_pixel = '';
$meta_token = '';
$google_snippet_code = '';
$google_label = '';

$stmt2 = $conn->prepare("SELECT meta_pixel, meta_token, google_snippet_code, google_label FROM integracoes_ads WHERE user_id = ? LIMIT 1");
$stmt2->bind_param("s", $user_id);
$stmt2->execute();
$stmt2->bind_result($meta_pixel, $meta_token, $google_snippet_code, $google_label);
$stmt2->fetch();
$stmt2->close();

$conn->close();
?>

<?php
    $baseUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . dirname($_SERVER['SCRIPT_NAME']) . '/../';
?>

<?php ob_start(); ?>
<style>
    .btn-integration { 
        padding: 10px 16px; 
        font-weight: 600; 
        font-size: 0.95rem; 
        border-radius: 8px; 
        white-space: nowrap; 
    }
    .card.integration {
        background: var(--custom-white, #1f1f1f);
    }
    .card.integration .card-body { padding: 18px 20px; }
    .integration-icon .avatar { width: 80px; height: 50px;    aspect-ratio: 1;
    }
    @media (max-width: 575px) {
        .btn-integration { width: 100%; }
    }
</style>

<?php $styles = ob_get_clean(); ?>

<?php ob_start(); ?>

            <div class="main-content app-content">
                <div class="container-fluid">

                    <div class="d-flex align-items-center justify-content-between my-4 page-header-breadcrumb flex-wrap gap-2">
                        <div>
                            <p class="fw-medium fs-20 mb-0">Olá, <?php echo htmlspecialchars($nome); ?></p>
                            <p class="fs-13 text-muted mb-0">Gerencie suas integrações de anúncios.</p>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-xl-6">
                            <div class="card custom-card integration">
                                <div class="card-body">
                                    <div class="d-flex align-items-center justify-content-between">
                                        <div class="d-flex align-items-center gap-2 integration-icon">
                                            <span class="avatar avatar-md bg-primary-transparent">
                                                <i class="ri-facebook-fill fs-20"></i>
                                            </span>
                                            <div>
                                                <h6 class="mb-1">Meta Ads</h6>
                                                <p class="mb-0 text-muted">Conecte sua conta do Meta Ads para rastrear conversões automaticamente.</p>
                                            </div>
                                        </div>
                                        <div class="d-flex gap-2">
                                            <?php if (!empty($meta_pixel) && !empty($meta_token)): ?>
                                                <button class="btn btn-outline-light btn-integration" data-bs-toggle="modal" data-bs-target="#modalMeta">Editar</button>
                                                <form method="POST" action="delete_meta.php" onsubmit="return confirm('Remover integração Meta?');">
                                                    <button type="submit" class="btn btn-danger btn-integration">Remover</button>
                                                </form>
                                            <?php else: ?>
                                                <button class="btn btn-primary btn-integration" data-bs-toggle="modal" data-bs-target="#modalMeta">Conectar Meta Ads</button>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-6">
                            <div class="card custom-card integration">
                                <div class="card-body">
                                    <div class="d-flex align-items-center justify-content-between">
                                        <div class="d-flex align-items-center gap-2 integration-icon">
                                            <span class="avatar avatar-md bg-info-transparent">
                                                <i class="ri-google-fill fs-20"></i>
                                            </span>
                                            <div>
                                                <h6 class="mb-1">Google Ads</h6>
                                                <p class="mb-0 text-muted">Conecte sua conta do Google Ads para rastrear conversões automaticamente.</p>
                                            </div>
                                        </div>
                                        <div class="d-flex gap-2">
                                            <?php if (!empty($google_snippet_code) && !empty($google_label)): ?>
                                                <button class="btn btn-outline-light btn-integration" data-bs-toggle="modal" data-bs-target="#modalGoogle">Editar</button>
                                                <form method="POST" action="delete_google.php" onsubmit="return confirm('Remover integração Google?');">
                                                    <button type="submit" class="btn btn-danger btn-integration">Remover</button>
                                                </form>
                                            <?php else: ?>
                                                <button class="btn btn-primary btn-integration" data-bs-toggle="modal" data-bs-target="#modalGoogle">Conectar Google Ads</button>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card custom-card">
                        <div class="card-header justify-content-between">
                            <div class="card-title">EVENTOS DE CONVERSÃO</div>
                            <!-- <div>
                                <a href="#" class="btn btn-success btn-integration" data-bs-toggle="tooltip" title="Executa um disparo de teste">Testar Integrações</a>
                            </div> -->
                        </div>
                        <div class="card-body">
                            <div class="row g-3">
                                <div class="col-xl-4 col-md-4">
                                    <div class="text-center p-4 border rounded-3 h-100">
                                        <div class="avatar avatar-lg bg-primary-transparent mb-3">
                                            <i class="ri-shopping-bag-3-line fs-22"></i>
                                        </div>
                                        <h6 class="mb-1">Compra Aprovada</h6>
                                        <p class="text-muted mb-0">Evento enviado automaticamente quando uma venda é aprovada.</p>
                                    </div>
                                </div>
                                <div class="col-xl-4 col-md-4">
                                    <div class="text-center p-4 border rounded-3 h-100">
                                        <div class="avatar avatar-lg bg-success-transparent mb-3">
                                            <i class="ri-refresh-line fs-22"></i>
                                        </div>
                                        <h6 class="mb-1">Sincronização</h6>
                                        <p class="text-muted mb-0">Dados sincronizados em tempo real com as plataformas.</p>
                                    </div>
                                </div>
                                <div class="col-xl-4 col-md-4">
                                    <div class="text-center p-4 border rounded-3 h-100">
                                        <div class="avatar avatar-lg bg-warning-transparent mb-3">
                                            <i class="ri-shield-keyhole-line fs-22"></i>
                                        </div>
                                        <h6 class="mb-1">Segurança</h6>
                                        <p class="text-muted mb-0">Tokens criptografados e armazenados com segurança.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>

            <!-- Modal Meta -->
            <div class="modal fade" id="modalMeta" tabindex="-1" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Conectar Meta Ads</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <form method="POST" action="save_meta.php">
                            <div class="modal-body">
                                <div class="mb-3">
                                    <label class="form-label">Pixel ID</label>
                                    <input type="text" class="form-control" name="meta_pixel" value="<?php echo htmlspecialchars($meta_pixel ?? ''); ?>" placeholder="Ex.: 123456789012345" required>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Token</label>
                                    <input type="text" class="form-control" name="meta_token" value="<?php echo htmlspecialchars($meta_token ?? ''); ?>" placeholder="Token de acesso" required>
                                </div>
                                <div class="alert alert-info">Importante: Suas credenciais serão armazenadas com segurança e usadas apenas para enviar eventos de conversão quando suas vendas forem aprovadas.</div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancelar</button>
                                <button type="submit" class="btn btn-primary">Salvar Integração</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Modal Google -->
            <div class="modal fade" id="modalGoogle" tabindex="-1" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Conectar Google Ads</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <form method="POST" action="save_google.php">
                            <div class="modal-body">
                                <div class="mb-3">
                                    <label class="form-label">Código do snippet</label>
                                    <input type="text" class="form-control" name="google_snippet_code" value="<?php echo htmlspecialchars($google_snippet_code ?? ''); ?>" placeholder="AW-XXXXXXXXX" required>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Label</label>
                                    <input type="text" class="form-control" name="google_label" value="<?php echo htmlspecialchars($google_label ?? ''); ?>" placeholder="XXXXXXX" required>
                                </div>
                                <div class="alert alert-info">Importante: Suas credenciais serão armazenadas com segurança e usadas apenas para enviar eventos de conversão quando suas vendas forem aprovadas.</div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancelar</button>
                                <button type="submit" class="btn btn-primary">Salvar Integração</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

<?php $content = ob_get_clean(); ?>

<?php ob_start(); ?>

<?php $scripts = ob_get_clean(); ?>

<?php include '../layouts/base.php'; ?>


