<?php
require_once 'config.php';

// Função asaasRequest será definida localmente no final do arquivo

header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *"); 
header("Access-Control-Allow-Methods: POST, OPTIONS"); 
header("Access-Control-Allow-Headers: Content-Type, Authorization"); 
 
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200); 
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    
   
  

    $requestData = json_decode(file_get_contents('php://input'), true);
    // var_dump($requestData);die;
    
    
    
      // Validação do api-key via GET
    if (!isset($requestData['api-key']) || empty($requestData['api-key'])) {
        http_response_code(400);
        echo json_encode([
            "status" => "error",
            "message" => "Campo obrigatório ausente: api-key"
        ]);
        exit;
    }
    
    
    // Validação dos dados obrigatórios
    if (!isset($requestData['amount'], $requestData['client'])) {
        http_response_code(400); 
        echo json_encode([
            "status" => "error", 
            "message" => getErrorMessage('MISSING_REQUIRED_FIELDS')
        ]);
        exit;
    }

    // Validação da estrutura do cliente
    if (!isset($requestData['client']['name'], $requestData['client']['document'], $requestData['client']['email'])) {
        http_response_code(400); 
        echo json_encode([
            "status" => "error", 
            "message" => getErrorMessage('INVALID_CLIENT_DATA')
        ]);
        exit;
    }
    
    // Validação adicional dos campos obrigatórios não podem estar vazios
    if (empty(trim($requestData['client']['name'])) || empty(trim($requestData['client']['document'])) || empty(trim($requestData['client']['email']))) {
        http_response_code(400); 
        echo json_encode([
            "status" => "error", 
            "message" => "Os campos name, document e email do cliente não podem estar vazios"
        ]);
        exit;
    }

    include 'conectarbanco.php';
    $conn = new mysqli('localhost', $config['db_user'], $config['db_pass'], $config['db_name']);

    if ($conn->connect_error) {
        http_response_code(500);
        echo json_encode([
            "status" => "error", 
            "message" => getErrorMessage('DATABASE_ERROR')
        ]);
        exit;
    }



    // Validar API key
    $sql = "SELECT user_id FROM users_key WHERE api_key = ? AND status = 'ativo'";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $requestData['api-key']);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows === 0) {
        http_response_code(401);
        echo json_encode([
            "status" => "error", 
            "message" => getErrorMessage('INVALID_API_KEY')
        ]);
        $stmt->close();
        $conn->close();
        exit;
    }

    $stmt->bind_result($usuario);
    $stmt->fetch();
    $stmt->close();

    // Verificar se Asaas está ativo como adquirente
    $sql_adquirente = "SELECT adquirente FROM adquirentes WHERE adquirente = 'asaas' AND status = 1 LIMIT 1";
    $stmt_adquirente = $conn->prepare($sql_adquirente);
    $stmt_adquirente->execute();
    $stmt_adquirente->store_result();

    if ($stmt_adquirente->num_rows === 0) {
        http_response_code(503);
        echo json_encode([
            "status" => "error", 
            "message" => getErrorMessage('ASAAS_UNAVAILABLE')
        ]);
        $stmt_adquirente->close();
        $conn->close();
        exit;
    }
    $stmt_adquirente->close();

    // Buscar configurações do Asaas
    $sql_asaas = "SELECT secret_key, url FROM ad_asaas WHERE id = 1";
    $stmt_asaas = $conn->prepare($sql_asaas);
    $stmt_asaas->execute();
    $stmt_asaas->bind_result($secret_key, $url);
    $stmt_asaas->fetch();
    $stmt_asaas->close();

    if (empty($secret_key)) {
        http_response_code(500);
        echo json_encode([
            "status" => "error", 
            "message" => getErrorMessage('ASAAS_ERROR')
        ]);
        $conn->close();
        exit;
    }

    try {
        // Criar cliente no Asaas
        $clientName = trim($requestData['client']['name']);
        $clientDocument = preg_replace('/[^0-9]/', '', $requestData['client']['document']);
        $clientEmail = trim($requestData['client']['email']);
        
        // Validações específicas para o Asaas
        if (strlen($clientName) < 2) {
            throw new Exception('O nome do cliente deve ter pelo menos 2 caracteres');
        }
        
        if (strlen($clientDocument) !== 11 && strlen($clientDocument) !== 14) {
            throw new Exception('Documento deve ser um CPF (11 dígitos) ou CNPJ (14 dígitos) válido');
        }
        
        if (!filter_var($clientEmail, FILTER_VALIDATE_EMAIL)) {
            throw new Exception('Email inválido');
        }
        
        $customerData = [
            'name' => $clientName,
            'cpfCnpj' => $clientDocument,
            'email' => $clientEmail
        ];
        
        $customerResponse = asaasRequest('customers', 'POST', $customerData);
        
        if (empty($customerResponse['id']) || isset($customerResponse['error']) || isset($customerResponse['errors'])) {
            $errorDetails = [];
            
            if (isset($customerResponse['errors']) && is_array($customerResponse['errors'])) {
                foreach ($customerResponse['errors'] as $error) {
                    $errorDetails[] = $error['description'] ?? $error['code'] ?? 'Erro desconhecido';
                }
                $errorMessage = 'Erros do Asaas: ' . implode(', ', $errorDetails);
            } elseif (isset($customerResponse['curl_error'])) {
                $errorMessage = 'Erro cURL: ' . $customerResponse['curl_error'];
            } else {
                $errorMessage = $customerResponse['message'] ?? 'Erro desconhecido';
            }
            
            throw new Exception('Erro ao criar cliente no Asaas: ' . $errorMessage);
        }

        // Criar pagamento PIX no Asaas
        $paymentData = [
            'customer' => $customerResponse['id'],
            'billingType' => 'PIX',
            'value' => floatval($requestData['amount']),
            'dueDate' => date('Y-m-d'),
            'description' => 'Pagamento via PIX - ' . $requestData['client']['name']
        ];

        $paymentResponse = asaasRequest('payments', 'POST', $paymentData);
        
        if (empty($paymentResponse['id']) || isset($paymentResponse['error']) || isset($paymentResponse['errors'])) {
            $errorDetails = [];
            
            if (isset($paymentResponse['errors']) && is_array($paymentResponse['errors'])) {
                foreach ($paymentResponse['errors'] as $error) {
                    $errorDetails[] = $error['description'] ?? $error['code'] ?? 'Erro desconhecido';
                }
                $errorMessage = 'Erros do Asaas: ' . implode(', ', $errorDetails);
            } elseif (isset($paymentResponse['curl_error'])) {
                $errorMessage = 'Erro cURL: ' . $paymentResponse['curl_error'];
            } else {
                $errorMessage = $paymentResponse['message'] ?? 'Erro desconhecido';
            }
            
            throw new Exception('Erro ao criar pagamento no Asaas: ' . $errorMessage);
        }

        // Buscar dados do PIX QR Code
        $pixResponse = asaasRequest("payments/{$paymentResponse['id']}/pixQrCode", 'GET');
        
        $paymentCode = $pixResponse['payload'] ?? '';
        $paymentCodeBase64 = $pixResponse['encodedImage'] ?? '';

        // Buscar taxas do usuário
        $sql_taxa = "SELECT taxa_cash_in FROM users WHERE user_id = ?";
        $stmt_taxa = $conn->prepare($sql_taxa);
        $stmt_taxa->bind_param("s", $usuario);
        $stmt_taxa->execute();
        $stmt_taxa->bind_result($taxa_cash_in);
        $stmt_taxa->fetch();
        $stmt_taxa->close();

        if ($taxa_cash_in === null) {
            $taxa_cash_in = getConfig('DEFAULT_TAXA_CASH_IN', 5.00);
        }

        // Calcular valor líquido
        $taxa_cash_in_percentage = $taxa_cash_in / 100;
        $amount = floatval($requestData['amount']);
        $deposito_liquido = $amount - ($amount * $taxa_cash_in_percentage);

        // Gerar referência externa única
        $externalReference = generateRandomString(32);
        $status = 'WAITING_FOR_APPROVAL';
        $horaAtual = date('Y-m-d H:i:s');

        // Salvar na base de dados
        $sql_insert = "INSERT INTO solicitacoes 
        (user_id, externalreference, amount, client_name, client_document, client_email, real_data, paymentCode, idtransaction, paymentCodeBase64, status, adquirente_ref, taxa_cash_in, deposito_liquido, client_telefone, postback) 
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        
        $stmt_insert = $conn->prepare($sql_insert);
        $postbackUrl = $requestData['postback'] ?? $_GET['postback'] ?? '';
        $adquirente = 'asaas';
        $clientTelefone = $requestData['client']['telefone'] ?? '';
        
        $stmt_insert->bind_param(
            "ssssssssssssssss",
            $usuario,
            $externalReference,
            $requestData['amount'],
            $requestData['client']['name'],
            $requestData['client']['document'],
            $requestData['client']['email'],
            $horaAtual,
            $paymentCode,
            $paymentResponse['id'],
            $paymentCodeBase64,
            $status,
            $adquirente,
            $taxa_cash_in,
            $deposito_liquido,
            $clientTelefone,
            $postbackUrl
        );

        if (!$stmt_insert->execute()) {
            throw new Exception('Erro ao salvar transação no banco de dados');
        }

        $stmt_insert->close();

        // Resposta de sucesso
        echo json_encode([
            "status" => "success",
            "message" => "Pagamento PIX criado com sucesso",
            "data" => [
                "idTransaction" => $paymentResponse['id'],
                "externalReference" => $externalReference,
                "paymentCode" => $paymentCode,
                "paymentCodeBase64" => $paymentCodeBase64,
                "amount" => $requestData['amount'],
                "status" => $status,
                "expiresAt" => $paymentResponse['dueDate'] ?? '',
                "pixKey" => $pixResponse['key'] ?? ''
            ]
        ]);

    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode([
            "status" => "error",
            "message" => $e->getMessage()
        ]);
    }

    $conn->close();
    } else {
        http_response_code(405);
        echo json_encode([
            "status" => "error", 
            "message" => getErrorMessage('INVALID_REQUEST_METHOD')
        ]);
    }

// Função para gerar string aleatória
function generateRandomString($length = 32) {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $charLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[random_int(0, $charLength - 1)];
    }
    return $randomString;
}

// Função para fazer requisições para o Asaas
function asaasRequest($endpoint, $method = 'POST', $data = null) {
    // Usar configuração local para manter independência
    $config = array(
        'db_user' => 'getpay_1',
        'db_pass' => '984380500Oi',
        'db_name' => 'getpay_1'
    );
    $conn = new mysqli('localhost', $config['db_user'], $config['db_pass'], $config['db_name']);

    if ($conn->connect_error) {
        return ['error' => true, 'message' => 'Erro na conexão com o banco: ' . $conn->connect_error];
    }

    $sql_asaas = "SELECT secret_key FROM ad_asaas WHERE id = 1";
    $stmt_asaas = $conn->prepare($sql_asaas);
    $stmt_asaas->execute();
    
    // precisa armazenar resultado para poder buscar
    $stmt_asaas->store_result();

    // vincular variáveis
    $stmt_asaas->bind_result($secret_key);

    if ($stmt_asaas->num_rows > 0) {
        $stmt_asaas->fetch();
    } else {
        return ['error' => true, 'message' => 'Nenhum registro encontrado em ad_asaas'];
    }

    $stmt_asaas->close();
    $conn->close();

    if (empty($secret_key)) {
        return ['error' => true, 'message' => 'Secret key do Asaas não configurada'];
    }
    
    $apiKey = $secret_key;
    $baseUrl = "https://www.asaas.com/api/v3";
    $fullUrl = "$baseUrl/$endpoint";

    $headers = [
        "Content-Type: application/json",
        "access_token: $apiKey",
        "User-Agent: MyApp/1.0"
    ];

    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $fullUrl,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_CUSTOMREQUEST => $method,
        CURLOPT_HTTPHEADER => $headers,
        CURLOPT_SSL_VERIFYPEER => false,
    ]);

    if ($data) {
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    }

    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        curl_close($ch);
        return ['curl_error' => curl_error($ch)];
    }
    
    curl_close($ch);
    return json_decode($response, true);
}
?>
