<?php
session_start();

// Verificar se o e-mail está presente na sessão
if (!isset($_SESSION['email'])) {
    // Se o e-mail não estiver presente na sessão, redirecione para outra página
    header("Location: ../");
    exit; // Certifique-se de sair do script após o redirecionamento
}

include '../conectarbanco.php';

$conn = new mysqli('localhost', $config['db_user'], $config['db_pass'], $config['db_name']);

// Verifica se houve algum erro na conexão
if ($conn->connect_error) {
    die("Erro na conexão com o banco de dados: " . $conn->connect_error);
}

// Recuperar o e-mail da sessão
$email = $_SESSION['email'];

// Consultar o status do usuário pelo email
$sql = "SELECT status FROM users WHERE email = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $email);
$stmt->execute();
$stmt->bind_result($status);
$stmt->fetch();

$stmt->close();
$conn->close();

// Verificar o status do usuário
if ($status == 0) {
    // Redirecionar imediatamente para a página ../home se o status for 0
    header("Location: ../home");
    exit;
}

// Verificar o status do usuário
if ($status == 5) {
    // Redirecionar imediatamente para a página ../home se o status for 0
    header("Location: ../home");
    exit;
}
?>




<?php
session_start();
function safe_number_format($num, $decimals = 2)
{
    // Se $num for null ou não for um número válido, substitui por 0
    return number_format(is_numeric($num) ? $num : 0, $decimals);
}
// Verificar se o e-mail está presente na sessão
if (!isset($_SESSION['email'])) {
    // Se o e-mail não estiver presente na sessão, redirecione para outra página
    header("Location: ../");
    exit; // Certifique-se de sair do script após o redirecionamento
}

include '../conectarbanco.php';

$conn = new mysqli('localhost', $config['db_user'], $config['db_pass'], $config['db_name']);

// Verifica se houve algum erro na conexão
if ($conn->connect_error) {
    die("Erro na conexão com o banco de dados: " . $conn->connect_error);
}

// Recuperar o e-mail da sessão
$email = $_SESSION['email'];

$sql = "SELECT user_id, nome, status, permission, saldo, transacoes_aproved, cliente_id FROM users WHERE email = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $email);
$stmt->execute();
$stmt->bind_result($user_id, $nome, $status, $permission, $saldo, $transacoes_aproved, $cliente_id);
$stmt->fetch();

// Armazenar os dados na sessão
$_SESSION['user_id'] = $user_id;
$_SESSION['cliente_id'] = $cliente_id; // Adiciona cliente_id à sessão

$stmt->close();
$conn->close();
?>




<?php

// Verifica se o parâmetro de logout foi passado na URL
if (isset($_GET['logout'])) {
    // Destroi a sessão
    session_destroy();
    // Redireciona para a página inicial
    header("Location: ../");
    exit;
}
?>


<?php
session_start();

// Verificar se o e-mail está presente na sessão
if (!isset($_SESSION['email'])) {
    // Se o e-mail não estiver presente na sessão, redirecione para outra página
    header("Location: ../");
    exit; // Certifique-se de sair do script após o redirecionamento
}

include '../conectarbanco.php';

// Obter o e-mail da sessão
$email = $_SESSION['email'];

// Conectar ao banco de dados
$conn = new mysqli('localhost', $config['db_user'], $config['db_pass'], $config['db_name']);

// Verifique a conexão
if ($conn->connect_error) {
    die("Falha na conexão: " . $conn->connect_error);
}

// Consulta para obter os dados da tabela checkout_build onde a coluna email é igual ao e-mail da sessão
$sql = "SELECT id, name_produto, valor, referencia, logo_produto, obrigado_page, key_gateway, ativo, url_checkout, parcelavel, max_parcelas 
        FROM checkout_build 
        WHERE email = ?";

// Preparar e executar a consulta
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $email);
$stmt->execute();

// Obter o resultado
$result = $stmt->get_result();
?>





<!-- Este código gera o URL base do site combinando o protocolo, o nome de domínio e o caminho do diretório -->
<?php
$baseUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . dirname($_SERVER['SCRIPT_NAME']) . '/../';
?>
<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->

<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->

<!-- This code is useful for internal styles  -->
<?php ob_start(); ?>



<?php $styles = ob_get_clean(); ?>
<!-- This code is useful for internal styles  -->

<!-- This code is useful for content -->
<?php ob_start(); ?>


<script>
    // Recuperar o user_id do PHP e imprimir no console
    const userId = <?php echo json_encode($_SESSION['user_id']); ?>;
    console.log("User ID:", userId);
</script>




<div class="main-content app-content">
    <div class="container-fluid">




        <!-- Start::row-1 -->
        <div class="row">
            <div class="col-xl-3">
                <div class="card custom-card">
                    <div class="card-body p-0">
                        <div class="p-3 d-grid border-bottom border-block-end-dashed">
                            <button class="btn btn-primary d-flex align-items-center justify-content-center"
                                data-bs-toggle="modal" data-bs-target="#addtask">
                                <i class="ri-add-circle-line fs-16 align-middle me-1"></i>Criar novo Checkout
                            </button>
                            <div class="modal fade" id="addtask" tabindex="-1" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-centered">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h6 class="modal-title" id="mail-ComposeLabel">Novo Checkout</h6>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>
                                        <form id="checkoutForm" method="POST" action="insert_checkout.php"
                                            enctype="multipart/form-data">
                                            <div class="modal-body px-4">
                                                <div class="row gy-2">
                                                    <div class="col-xl-12">
                                                        <label for="produto_name" class="form-label">Nome do
                                                            Produto</label>
                                                        <input type="text" class="form-control" id="produto_name"
                                                            name="produto_name" placeholder="Produto" required>
                                                    </div>
                                                    <div class="col-xl-12">
                                                        <label for="valor_checkout" class="form-label">Valor</label>
                                                        <input type="text" class="form-control" id="valor_checkout"
                                                            name="valor_checkout" placeholder="Valor (mínimo R$ 5,00)" required>
                                                        <div class="form-text">Valor mínimo: R$ 5,00</div>
                                                    </div>
                                                    <div class="col-xl-12">
                                                        <label for="obrigado_page" class="form-label">Página de Obrigado (opcional)</label>
                                                        <input type="text" class="form-control" id="obrigado_page"
                                                            name="obrigado_page" placeholder="Deixe em branco para usar a página padrão">
                                                    </div>

                                                    <div class="col-xl-8">
                                                        <label for="formFile" class="form-label">Foto do Produto</label>
                                                        <input class="form-control" type="file" id="formFile"
                                                            name="formFile" accept=".jpg, .jpeg, .png, .gif" required>
                                                    </div>


                                                    <div class="col-xl-12">
                                                        <label for="bannerFile" class="form-label">Banner do
                                                            Produto</label>
                                                        <input class="form-control" type="file" id="bannerFile"
                                                            name="bannerFile" accept=".jpg, .jpeg, .png, .gif" required>
                                                        <div class="alert alert-info mt-4">

                                                            <p>Por favor, faça o upload de um banner nas dimensões
                                                                recomendadas: 1200x400 pixels.</p>

                                                        </div>

                                                    </div>

                                                    <div class="col-xl-6">
                                                        <label for="parcelavel" class="form-label">Parcelamento</label>
                                                        <select class="form-control" id="parcelavel" name="parcelavel" required>
                                                            <option value="0">Não parcelável</option>
                                                            <option value="1">Parcelável</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-xl-6" id="max_parcelas_container" style="display: none;">
                                                        <label for="max_parcelas" class="form-label">Máximo de Parcelas</label>
                                                        <select class="form-control" id="max_parcelas" name="max_parcelas">
                                                            <option value="1">1x</option>
                                                            <option value="2">2x</option>
                                                            <option value="3">3x</option>
                                                            <option value="4">4x</option>
                                                            <option value="5">5x</option>
                                                            <option value="6">6x</option>
                                                            <option value="7">7x</option>
                                                            <option value="8">8x</option>
                                                            <option value="9">9x</option>
                                                            <option value="10">10x</option>
                                                            <option value="11">11x</option>
                                                            <option value="12">12x</option>
                                                        </select>
                                                        <div class="form-text">Valor mínimo por parcela: R$ 5,00</div>
                                                    </div>
                                                    <div class="col-xl-4">
                                                        <label for="status" class="form-label">Status</label>
                                                        <select class="form-control" id="status" name="status" required>
                                                            <option value="1">Ativo</option>

                                                        </select>
                                                    </div>

                                                    <!-- Campo oculto para cliente_id -->
                                                    <input type="hidden" id="cliente_id" name="cliente_id"
                                                        value="<?php echo $_SESSION['cliente_id']; ?>">
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-light"
                                                    data-bs-dismiss="modal">Cancel</button>
                                                <button type="submit" class="btn btn-primary">Create</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="p-3 task-navigation border-bottom border-block-end-dashed">
                        </div>
                    </div>
                </div>
            </div>





            <div class="col-xl-9">
                <div class="card custom-card">
                    <div class="card-header justify-content-between">
                        <div class="card-title">
                            Produtos
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table text-nowrap table-bordered">
                                <thead>
                                    <tr>
                                        <th scope="col">Produto</th>
                                        <th scope="col">Status</th>
                                        <th scope="col">Valor</th>
                                        <th scope="col">Link Checkout</th>
                                        <th scope="col">Ações</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    if ($result->num_rows > 0) {
                                        // Itera sobre os resultados e exibe cada linha na tabela
                                        while ($row = $result->fetch_assoc()) {
                                            $statusBadge = $row['ativo'] ? 'bg-success-transparent' : 'bg-light text-dark';
                                            $statusText = $row['ativo'] ? 'Active' : 'Inactive';
                                            // Supondo que $row['url_checkout'] contenha a URL original
                                            $url_checkout = $row['url_checkout'];

                                            // Cria o URL para o segundo botão, substituindo 'v1' por 'v2'
                                            $url_checkout_v2 = str_replace('v1', 'v2', $url_checkout);
                                            echo "<tr>";
                                            echo "<th scope='row'>";
                                            echo "<div class='d-flex align-items-center'>";
                                            echo "<span class='avatar avatar-xs me-2 online avatar-rounded'>";
                                            echo "<img src='{$row['logo_produto']}' alt='img'>";
                                            echo "</span>{$row['name_produto']}";
                                            echo "</div>";
                                            echo "</th>";
                                            echo "<td><span class='badge {$statusBadge}'>{$statusText}</span></td>";
                                            echo "<td>RS " . safe_number_format($row['valor'], 2, ',', '.') . "</td>";
                                            echo "<td>";
                                            // Adiciona um botão que redireciona para a URL do checkout em uma nova guia
                                            echo "
                                <a href='{$url_checkout}' class='btn btn-primary' target='_blank'>DIGITAL</a>";
                                            // <a href='{$url_checkout_v2}' class='btn btn-primary' target='_blank'>FISICO</a> Outro checkout
                                            echo "</td>";
                                            echo "<td>";
                                            echo "<div class='hstack gap-2 flex-wrap'>";
                                            echo "<a href='#' class='btn btn-info btn-edit' data-bs-toggle='modal' data-bs-target='#editModal' data-id='{$row['id']}' data-name='{$row['name_produto']}' data-value='{$row['valor']}' data-thank-you-page='{$row['obrigado_page']}' data-status='{$row['ativo']}' data-parcelavel='{$row['parcelavel']}' data-max-parcelas='{$row['max_parcelas']}'><i class='ri-edit-line'></i></a>";
                                            echo "<a href='deletar_produto.php?id={$row['id']}' class='btn btn-danger btn-delete' onclick='return confirm(\"Você tem certeza que deseja excluir este produto?\")'><i class='ri-delete-bin-5-line'></i></a>";
                                            echo "</div>";
                                            echo "</td>";
                                            echo "</tr>";
                                        }
                                    } else {
                                        echo "<tr><td colspan='5'>Nenhum produto encontrado</td></tr>";
                                    }
                                    $conn->close();
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>



        </div>
        <!--End::row-1 -->




        <!-- Modal para Editar Checkout -->
        <div class="modal fade" id="editModal" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h6 class="modal-title" id="editModalLabel">Editar Checkout</h6>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form id="editForm" method="POST" action="update_checkout.php">

                        <div class="modal-body px-4">
                            <input type="hidden" id="edit_id" name="id">
                            <div class="row gy-2">
                                <div class="col-xl-12">
                                    <label for="edit_valor_checkout" class="form-label">Valor</label>
                                    <input type="text" class="form-control" id="edit_valor_checkout"
                                        name="valor_checkout" placeholder="Valor (mínimo R$ 5,00)">
                                    <div class="form-text">Valor mínimo: R$ 5,00</div>
                                </div>
                                <div class="col-xl-6">
                                    <label for="edit_parcelavel" class="form-label">Parcelamento</label>
                                    <select class="form-control" id="edit_parcelavel" name="parcelavel">
                                        <option value="0">Não parcelável</option>
                                        <option value="1">Parcelável</option>
                                    </select>
                                </div>
                                <div class="col-xl-6" id="edit_max_parcelas_container" style="display: none;">
                                    <label for="edit_max_parcelas" class="form-label">Máximo de Parcelas</label>
                                    <select class="form-control" id="edit_max_parcelas" name="max_parcelas">
                                        <option value="1">1x</option>
                                        <option value="2">2x</option>
                                        <option value="3">3x</option>
                                        <option value="4">4x</option>
                                        <option value="5">5x</option>
                                        <option value="6">6x</option>
                                        <option value="7">7x</option>
                                        <option value="8">8x</option>
                                        <option value="9">9x</option>
                                        <option value="10">10x</option>
                                        <option value="11">11x</option>
                                        <option value="12">12x</option>
                                    </select>
                                    <div class="form-text">Valor mínimo por parcela: R$ 5,00</div>
                                </div>
                                <div class="col-xl-12">
                                    <label for="edit_obrigado_page" class="form-label">Página de Obrigado</label>
                                    <input type="text" class="form-control" id="edit_obrigado_page" name="obrigado_page"
                                        placeholder="URL da Página de Obrigado">
                                </div>

                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancelar</button>
                            <button type="submit" class="btn btn-primary">Salvar alterações</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <script>
            document.addEventListener('DOMContentLoaded', function () {
                // Função para mostrar/ocultar campo de parcelas
                function toggleParcelasField(selectElement, containerId) {
                    const container = document.getElementById(containerId);
                    if (selectElement.value === '1') {
                        container.style.display = 'block';
                    } else {
                        container.style.display = 'none';
                    }
                }

                // Event listeners para campos de parcelamento na criação
                const parcelavelSelect = document.getElementById('parcelavel');
                if (parcelavelSelect) {
                    parcelavelSelect.addEventListener('change', function() {
                        toggleParcelasField(this, 'max_parcelas_container');
                    });
                }

                // Event listeners para campos de parcelamento na edição
                const editParcelavelSelect = document.getElementById('edit_parcelavel');
                if (editParcelavelSelect) {
                    editParcelavelSelect.addEventListener('change', function() {
                        toggleParcelasField(this, 'edit_max_parcelas_container');
                    });
                }

                // Seleciona todos os botões de edição
                const editButtons = document.querySelectorAll('.btn-edit');

                // Adiciona um listener de evento para cada botão
                editButtons.forEach(button => {
                    button.addEventListener('click', function () {
                        // Obtém os dados do atributo data-*
                        const id = this.getAttribute('data-id');
                        const name = this.getAttribute('data-name');
                        const value = this.getAttribute('data-value');
                        const thankYouPage = this.getAttribute('data-thank-you-page');
                        const status = this.getAttribute('data-status');
                        const parcelavel = this.getAttribute('data-parcelavel');
                        const maxParcelas = this.getAttribute('data-max-parcelas');

                        // Preenche os campos do modal com os dados
                        document.getElementById('edit_id').value = id;
                        document.getElementById('edit_valor_checkout').value = value;
                        document.getElementById('edit_obrigado_page').value = thankYouPage;
                        document.getElementById('edit_parcelavel').value = parcelavel || '0';
                        document.getElementById('edit_max_parcelas').value = maxParcelas || '1';

                        // Mostra/oculta campo de parcelas baseado no valor
                        toggleParcelasField(document.getElementById('edit_parcelavel'), 'edit_max_parcelas_container');
                    });
                });

                // Validação de valor mínimo
                function validateMinimumValue(inputElement, minValue = 5.00) {
                    const value = parseFloat(inputElement.value.replace(/[^\d,]/g, '').replace(',', '.'));
                    if (value < minValue) {
                        inputElement.setCustomValidity(`Valor mínimo: R$ ${minValue.toFixed(2).replace('.', ',')}`);
                        return false;
                    } else {
                        inputElement.setCustomValidity('');
                        return true;
                    }
                }

                // Validação de valor por parcela (sem alerta visual)
                function validateInstallmentValue(valorInput, parcelasSelect, minValuePerInstallment = 5.00, showAlert = false) {
                    const valor = parseFloat(valorInput.value.replace(/[^\d,]/g, '').replace(',', '.'));
                    const parcelas = parseInt(parcelasSelect.value);
                    const valorPorParcela = valor / parcelas;
                    
                    if (valorPorParcela < minValuePerInstallment) {
                        const message = `Valor por parcela: R$ ${valorPorParcela.toFixed(2).replace('.', ',')} - Mínimo: R$ ${minValuePerInstallment.toFixed(2).replace('.', ',')}`;
                        parcelasSelect.setCustomValidity(message);
                        if (showAlert) {
                            showCustomAlert(message, 'error', 5000);
                        }
                        return false;
                    } else {
                        parcelasSelect.setCustomValidity('');
                        return true;
                    }
                }

                // Validação completa antes de submeter o formulário
                function validateFormBeforeSubmit(formElement) {
                    const valorInput = formElement.querySelector('#valor_checkout, #edit_valor_checkout');
                    const parcelavelSelect = formElement.querySelector('#parcelavel, #edit_parcelavel');
                    const maxParcelasSelect = formElement.querySelector('#max_parcelas, #edit_max_parcelas');
                    
                    if (!valorInput) return true;
                    
                    // Valida valor mínimo
                    if (!validateMinimumValue(valorInput)) {
                        showCustomAlert('Valor mínimo: R$ 5,00', 'error', 4000);
                        return false;
                    }
                    
                    // Se for parcelável, valida valor por parcela (com alerta)
                    if (parcelavelSelect && parcelavelSelect.value === '1' && maxParcelasSelect) {
                        if (!validateInstallmentValue(valorInput, maxParcelasSelect, 5.00, true)) {
                            return false;
                        }
                    }
                    
                    return true;
                }

                // Event listeners para validação
                const valorInput = document.getElementById('valor_checkout');
                const editValorInput = document.getElementById('edit_valor_checkout');
                const maxParcelasSelect = document.getElementById('max_parcelas');
                const editMaxParcelasSelect = document.getElementById('edit_max_parcelas');

                if (valorInput) {
                    valorInput.addEventListener('blur', function() {
                        validateMinimumValue(this);
                    });
                }

                if (editValorInput) {
                    editValorInput.addEventListener('blur', function() {
                        validateMinimumValue(this);
                    });
                }

                if (maxParcelasSelect && valorInput) {
                    maxParcelasSelect.addEventListener('change', function() {
                        validateInstallmentValue(valorInput, this, 5.00, false); // Sem alerta visual
                    });
                }

                if (editMaxParcelasSelect && editValorInput) {
                    editMaxParcelasSelect.addEventListener('change', function() {
                        validateInstallmentValue(editValorInput, this, 5.00, false); // Sem alerta visual
                    });
                }

                // Event listeners para formulários
                const checkoutForm = document.getElementById('checkoutForm');
                const editForm = document.getElementById('editForm');

                if (checkoutForm) {
                    checkoutForm.addEventListener('submit', function(e) {
                        e.preventDefault();
                        
                        if (!validateFormBeforeSubmit(this)) {
                            return false;
                        }
                        
                        // Submissão via AJAX
                        const formData = new FormData(this);
                        
                        fetch('insert_checkout.php', {
                            method: 'POST',
                            body: formData
                        })
                        .then(response => {
                            const contentType = response.headers.get('content-type');
                            if (contentType && contentType.includes('application/json')) {
                                return response.json();
                            } else {
                                return response.text().then(text => {
                                    throw new Error(text || 'Erro no servidor');
                                });
                            }
                        })
                        .then(data => {
                            if (data.success) {
                                showCustomAlert(data.message, 'success', 3000);
                                setTimeout(() => {
                                    window.location.href = data.redirect;
                                }, 1500);
                            } else {
                                showCustomAlert(data.message, 'error', 5000);
                            }
                        })
                        .catch(error => {
                            showCustomAlert(error.message || 'Erro ao processar solicitação', 'error', 4000);
                            console.error('Error:', error);
                        });
                    });
                }

                if (editForm) {
                    editForm.addEventListener('submit', function(e) {
                        e.preventDefault();
                        
                        if (!validateFormBeforeSubmit(this)) {
                            return false;
                        }
                        
                        // Submissão via AJAX
                        const formData = new FormData(this);
                        
                        fetch('update_checkout.php', {
                            method: 'POST',
                            body: formData
                        })
                        .then(response => {
                            const contentType = response.headers.get('content-type');
                            if (contentType && contentType.includes('application/json')) {
                                return response.json();
                            } else {
                                return response.text().then(text => {
                                    throw new Error(text || 'Erro no servidor');
                                });
                            }
                        })
                        .then(data => {
                            if (data.success) {
                                showCustomAlert(data.message, 'success', 3000);
                                setTimeout(() => {
                                    window.location.href = data.redirect;
                                }, 1500);
                            } else {
                                showCustomAlert(data.message, 'error', 5000);
                            }
                        })
                        .catch(error => {
                            showCustomAlert(error.message || 'Erro ao processar solicitação', 'error', 4000);
                            console.error('Error:', error);
                        });
                    });
                }

                // Validação silenciosa em tempo real (apenas para validação HTML5)
                if (valorInput && maxParcelasSelect) {
                    valorInput.addEventListener('input', function() {
                        if (document.getElementById('parcelavel').value === '1') {
                            setTimeout(() => validateInstallmentValue(this, maxParcelasSelect, 5.00, false), 100);
                        }
                    });
                }

                if (editValorInput && editMaxParcelasSelect) {
                    editValorInput.addEventListener('input', function() {
                        if (document.getElementById('edit_parcelavel').value === '1') {
                            setTimeout(() => validateInstallmentValue(this, editMaxParcelasSelect, 5.00, false), 100);
                        }
                    });
                }
            });
        </script>







    </div>
</div>

<?php $content = ob_get_clean(); ?>
<!-- This code is useful for content -->

<!-- This code is useful for internal scripts  -->
<?php ob_start(); ?>

<!-- Apex Charts JS -->
<script src="<?php echo $baseUrl; ?>/assets/libs/apexcharts/apexcharts.min.js"></script>

<!-- Sistema de Alertas Customizados -->
<?php include '../checkout/v1/alerta_customizado.php'; ?>



<?php $scripts = ob_get_clean(); ?>
<!-- This code is useful for internal scripts  -->

<!-- This code use for render base file -->
<?php include '../layouts/base.php'; ?>
<!-- This code use for render base file -->



<!-- Dragula JS -->
<script src="<?php echo $baseUrl; ?>/assets/libs/dragula/dragula.min.js"></script>

<!-- Internal To-Do-List JS -->
<script src="<?php echo $baseUrl; ?>/assets/js/todolist.js"></script>

<script>
    // Função para formatar o campo Valor na criação do produto
    document.getElementById('valor_checkout').addEventListener('input', function (e) {
        let value = e.target.value.replace(/\D/g, '');

        if (value.length > 0) {
            value = (parseFloat(value) / 100).toFixed(2);
            value = value.replace('.', ',');
            value = value.replace(/\B(?=(\d{3})+(?!\d))/g, '.');
        }

        e.target.value = value;
    });

    // Função para formatar o campo Valor ao editar o produto
    document.getElementById('edit_valor_checkout').addEventListener('input', function (e) {
        let value = e.target.value.replace(/\D/g, '');

        if (value.length > 0) {
            value = (parseFloat(value) / 100).toFixed(2);
            value = value.replace('.', ',');
            value = value.replace(/\B(?=(\d{3})+(?!\d))/g, '.');
        }

        e.target.value = value;
    });
</script>