<?php
/**
 * Template da página de pagamento PIX
 */

if (!defined('ABSPATH')) {
    exit;
}

$order = wc_get_order($order_id);
if (!$order) {
    return;
}

$payment_id = $order->get_meta('_pix_payment_id');
$payment_code = $order->get_meta('_pix_payment_code');
$payment_code_base64 = $order->get_meta('_pix_payment_code_base64');
$expires_at = $order->get_meta('_pix_expires_at');
$pix_key = $order->get_meta('_pix_pix_key');
$amount = $order->get_total();
?>

<div class="pix-payment-container">
    <div class="pix-payment-header">
        <h2><?php _e('Pagamento PIX', 'woocommerce-pix-gateway'); ?></h2>
        <p><?php _e('Escaneie o QR Code abaixo com seu aplicativo bancário para realizar o pagamento.', 'woocommerce-pix-gateway'); ?></p>
    </div>

    <div class="pix-payment-details">
        <div class="pix-amount">
            <span class="label"><?php _e('Valor:', 'woocommerce-pix-gateway'); ?></span>
            <span class="value">R$ <?php echo number_format($amount, 2, ',', '.'); ?></span>
        </div>
        
        <div class="pix-expiration">
            <span class="label"><?php _e('Expira em:', 'woocommerce-pix-gateway'); ?></span>
            <span class="value"><?php echo $expires_at; ?></span>
        </div>
        
        <div class="pix-order-id">
            <span class="label"><?php _e('Pedido:', 'woocommerce-pix-gateway'); ?></span>
            <span class="value">#<?php echo $order->get_order_number(); ?></span>
        </div>
    </div>

    <div class="pix-qr-code">
        <?php if ($payment_code_base64): ?>
            <div class="qr-code-container">
                <img src="data:image/png;base64,<?php echo esc_attr($payment_code_base64); ?>" 
                     alt="<?php _e('QR Code PIX', 'woocommerce-pix-gateway'); ?>"
                     class="pix-qr-image">
            </div>
        <?php endif; ?>
        
        <div class="pix-copy-code">
            <p><?php _e('Ou copie o código PIX abaixo:', 'woocommerce-pix-gateway'); ?></p>
            <div class="code-container">
                <textarea id="pix-code" readonly class="pix-code-textarea"><?php echo esc_textarea($payment_code); ?></textarea>
                <button type="button" class="copy-pix-code" onclick="copyPixCode()">
                    <?php _e('Copiar', 'woocommerce-pix-gateway'); ?>
                </button>
            </div>
        </div>
    </div>

    <div class="pix-instructions">
        <h3><?php _e('Como pagar:', 'woocommerce-pix-gateway'); ?></h3>
        <ol>
            <li><?php _e('Abra o aplicativo do seu banco', 'woocommerce-pix-gateway'); ?></li>
            <li><?php _e('Escolha a opção PIX', 'woocommerce-pix-gateway'); ?></li>
            <li><?php _e('Escaneie o QR Code ou cole o código PIX', 'woocommerce-pix-gateway'); ?></li>
            <li><?php _e('Confirme o pagamento', 'woocommerce-pix-gateway'); ?></li>
        </ol>
    </div>

    <div class="pix-status-check">
        <p><?php _e('Após realizar o pagamento, o status será atualizado automaticamente.', 'woocommerce-pix-gateway'); ?></p>
        <button type="button" class="check-pix-status" onclick="checkPixStatus()">
            <?php _e('Verificar Status', 'woocommerce-pix-gateway'); ?>
        </button>
    </div>

    <div class="pix-payment-footer">
        <p class="pix-note">
            <strong><?php _e('Importante:', 'woocommerce-pix-gateway'); ?></strong>
            <?php _e('O pagamento PIX é processado instantaneamente. Após a confirmação, seu pedido será processado automaticamente.', 'woocommerce-pix-gateway'); ?>
        </p>
        
        <div class="pix-support">
            <p><?php _e('Precisa de ajuda?', 'woocommerce-pix-gateway'); ?> 
               <a href="<?php echo esc_url(home_url('/contato')); ?>"><?php _e('Entre em contato', 'woocommerce-pix-gateway'); ?></a>
            </p>
        </div>
    </div>
</div>

<script type="text/javascript">
function copyPixCode() {
    const textarea = document.getElementById('pix-code');
    textarea.select();
    textarea.setSelectionRange(0, 99999);
    
    try {
        document.execCommand('copy');
        alert('<?php _e('Código PIX copiado!', 'woocommerce-pix-gateway'); ?>');
    } catch (err) {
        console.error('Erro ao copiar: ', err);
    }
}

function checkPixStatus() {
    const button = document.querySelector('.check-pix-status');
    const originalText = button.textContent;
    
    button.textContent = '<?php _e('Verificando...', 'woocommerce-pix-gateway'); ?>';
    button.disabled = true;
    
    // Fazer requisição AJAX para verificar status
    jQuery.ajax({
        url: wc_pix_gateway.ajax_url,
        type: 'POST',
        data: {
            action: 'wc_pix_gateway_check_status',
            order_id: <?php echo $order->get_id(); ?>,
            nonce: wc_pix_gateway.nonce
        },
        success: function(response) {
            if (response.success) {
                if (response.data.status === 'PAID_OUT') {
                    alert('<?php _e('Pagamento confirmado! Redirecionando...', 'woocommerce-pix-gateway'); ?>');
                    window.location.href = '<?php echo esc_url($order->get_checkout_order_received_url()); ?>';
                } else {
                    alert('<?php _e('Pagamento ainda não foi confirmado. Tente novamente em alguns instantes.', 'woocommerce-pix-gateway'); ?>');
                }
            } else {
                alert('<?php _e('Erro ao verificar status. Tente novamente.', 'woocommerce-pix-gateway'); ?>');
            }
        },
        error: function() {
            alert('<?php _e('Erro ao verificar status. Tente novamente.', 'woocommerce-pix-gateway'); ?>');
        },
        complete: function() {
            button.textContent = originalText;
            button.disabled = false;
        }
    });
}

// Verificar status automaticamente a cada 30 segundos
setInterval(function() {
    if (document.visibilityState === 'visible') {
        checkPixStatus();
    }
}, 30000);
</script>
